/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigBase;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Utilities {
    public static void addDungeonLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        config.setCategoryComment("Dungeon Loot Enabled", "Here you can enable/disable dungeon loot for various types of dungeons.");
        if (config.getBool("Dungeon Loot Enabled", "Dungeons", true, "These are most dungeons from underground mob spawner dungeons to pyramids, mineshafts and jungle temples.")) {
            // empty if block
        }
    }

    public static void addStrongholdLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        if (config.getBool("Dungeon Loot Enabled", "Strongholds", true, "Stronghold dungeons including corridors, libraries and other parts.")) {
            // empty if block
        }
    }

    public static void addVillageLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        if (config.getBool("Dungeon Loot Enabled", "Blacksmiths", true, "These are the chests found in village blacksmiths homes.")) {
            // empty if block
        }
    }

    public static RayTraceResult raytrace(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, HashSet<Entity> excluded) {
        Vec3d startVec = new Vec3d(x, y, z);
        Vec3d lookVec = new Vec3d(tx - x, ty - y, tz - z);
        Vec3d endVec = new Vec3d(tx, ty, tz);
        float minX = (float)(x < tx ? x : tx);
        float minY = (float)(y < ty ? y : ty);
        float minZ = (float)(z < tz ? z : tz);
        float maxX = (float)(x > tx ? x : tx);
        float maxY = (float)(y > ty ? y : ty);
        float maxZ = (float)(z > tz ? z : tz);
        RayTraceResult collision = world.func_72901_a(startVec, endVec, false);
        startVec = new Vec3d(x, y, z);
        endVec = new Vec3d(tx, ty, tz);
        float maxDistance = (float)endVec.func_72438_d(startVec);
        if (collision != null) {
            maxDistance = (float)collision.field_72307_f.func_72438_d(startVec);
        }
        if (excluded != null) {
            AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            List allEntities = world.func_72839_b(null, bb);
            Entity closestHitEntity = null;
            float closestHit = Float.POSITIVE_INFINITY;
            for (Entity ent : allEntities) {
                float currentHit;
                RayTraceResult intercept;
                if (!ent.func_70067_L() || excluded.contains(ent)) continue;
                float entBorder = ent.func_70111_Y();
                AxisAlignedBB entityBb = ent.func_174813_aQ();
                if (entityBb == null || (intercept = (entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
                closestHit = currentHit;
                closestHitEntity = ent;
            }
            if (closestHitEntity != null) {
                collision = new RayTraceResult(closestHitEntity);
            }
        }
        return collision;
    }

    public static RayTraceResult raytraceEntities(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, HashSet<Entity> excluded) {
        Vec3d startVec = new Vec3d(x, y, z);
        Vec3d lookVec = new Vec3d(tx - x, ty - y, tz - z);
        Vec3d endVec = new Vec3d(tx, ty, tz);
        float minX = (float)(x < tx ? x : tx);
        float minY = (float)(y < ty ? y : ty);
        float minZ = (float)(z < tz ? z : tz);
        float maxX = (float)(x > tx ? x : tx);
        float maxY = (float)(y > ty ? y : ty);
        float maxZ = (float)(z > tz ? z : tz);
        AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        RayTraceResult collision = world.func_72901_a(startVec, endVec, false);
        Entity closestHitEntity = null;
        float closestHit = Float.POSITIVE_INFINITY;
        float currentHit = 0.0f;
        for (Entity ent : allEntities) {
            RayTraceResult intercept;
            if (!ent.func_70067_L() || excluded.contains(ent)) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.func_174813_aQ();
            if (entityBb == null || (intercept = (entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            collision = new RayTraceResult(closestHitEntity);
        }
        return collision;
    }

    public static boolean isHalloween() {
        block4: {
            block3: {
                Calendar calendar;
                block2: {
                    calendar = Calendar.getInstance();
                    if (calendar.get(5) != 31) break block2;
                    if (calendar.get(2) == 9) break block3;
                }
                if (calendar.get(5) != 1) break block4;
                if (calendar.get(2) != 10) break block4;
            }
            return true;
        }
        return false;
    }

    public static boolean isYuletide() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) > 9 && calendar.get(5) < 26;
    }

    public static boolean isYuletideDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) == 25;
    }

    public static boolean isNewYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 0 && calendar.get(5) == 1;
    }
}

